<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\LeaversHoodies;

use JMS\Serializer\Annotation as Serializer;

class HoodieRequestResponse
{
    /**
     * The order reference provided by the user
     *
     * @Serializer\Type("string")
     */
    public ?string $orderReference = null;

    /**
     * The name of the school
     *
     * @Serializer\Type("string")
     */
    public ?string $schoolName = null;

    /**
     * An alternate version of the school name - to be printed
     *
     * @Serializer\Type("string")
     */
    public ?string $alternateName = null;

    /**
     * The user's ideal delivery date
     *
     * @Serializer\Type("string")
     */
    public ?string $idealDeliveryDate = null;

    /**
     * Back design option
     *
     * @Serializer\Type("string")
     */
    public ?string $backDesignOption = null;

    /**
     * Back design image path
     *
     * @Serializer\Type("string")
     */
    public ?string $backImage = null;

    /**
     * Front left type - embroidery or print
     *
     * @Serializer\Type("string")
     */
    public ?string $frontLeftType = null;

    /**
     * Embroidery image path
     *
     * @Serializer\Type("string")
     */
    public ?string $embroideryImage = null;

    /**
     * Front left notes
     *
     * @Serializer\Type("string")
     */
    public ?string $frontLeftNotes = null;

    /**
     * Right chest design option
     *
     * @Serializer\Type("string")
     */
    public ?string $rightChestDesignOption = null;

    /**
     * Right chest image path
     *
     * @Serializer\Type("string")
     */
    public ?string $rightChestDesignImage = null;

    /**
     * Left sleeve design option
     *
     * @Serializer\Type("string")
     */
    public ?string $leftSleeveOption = null;

    /**
     * Hoodie Colour
     *
     * @Serializer\Type("string")
     */
    public ?string $hoodieColour = null;

    /**
     * Spreadsheet file path
     *
     * @Serializer\Type("string")
     */
    public ?string $spreadsheet = null;

    /**
     * Delivery address
     *
     * @Serializer\Type("string")
     */
    public ?string $deliveryAddress = null;

    /**
     * Notes
     *
     * @Serializer\Type("string")
     */
    public ?string $notes = null;
}
