<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Basket;

use JMS\Serializer\Annotation as Serializer;

class BasketResponse
{
    /**
     * @Serializer\Type("int")
     */
    public int $itemCount = 0;
    /**
     * @Serializer\Type("string")
     */
    public string $subtotal = '0.00';
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("subtotal_exc_surcharges")
     */
    public string $subtotalExcludingSurcharges = '0.00';
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("subtotal_exc_delivery")
     */
    public string $subtotalExcludingDelivery = '0.00';
    /**
     * @Serializer\Type("string")
     */
    public string $tax = '0.00';
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("tax_exc_delivery")
     */
    public string $taxExcludingDelivery = '0.00';
    /**
     * @Serializer\Type("string")
     */
    public string $total = '0.00';
    /**
     * @var array<ItemResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Basket\ItemResponse>")
     */
    public array $items = [];
    /**
     * @var array<MessageResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Basket\MessageResponse>")
     */
    public array $errors = [];
    /**
     * @var array<SurchargeResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Basket\SurchargeResponse>")
     */
    public array $surcharges = [];
    /**
     * @Serializer\Type("string")
     */
    public ?string $orderType = null;
    /**
     * @Serializer\Type("int")
     */
    public ?int $deliveryOption = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $deliveryPrice = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $deliveryTax = null;
    /**
     * @Serializer\Type("bool")
     */
    public bool $freeDeliveryEligible = false;
    /**
     * @Serializer\Type("string")
     */
    public string $amountUntilFreeDelivery = '0.00';
}
