<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\User;

use JMS\Serializer\Annotation as Serializer;

/**
 * @internal
 */
class UpdateRequest
{
    public ?string $jobTitle = null;
    public ?string $email = null;
    public ?string $phoneMobile = null;
    public ?string $phoneLand = null;
    /**
     * @Serializer\SerializedName("enabled_2fa")
     * @Serializer\Type("bool")
     */
    public ?bool $enabled2FA = null;
    public ?string $password = null;
    private ?string $firstName = null; // @phpstan-ignore-line
    private ?string $lastName = null; // @phpstan-ignore-line

    public function __construct(
        ?string $firstName,
        ?string $lastName,
        ?string $jobTitle,
        ?string $email,
        ?string $phoneMobile,
        ?string $phoneLand,
        ?bool $enabled2FA,
        ?string $password
    ) {
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->jobTitle = $jobTitle;
        $this->email = $email;
        $this->phoneMobile = $phoneMobile;
        $this->phoneLand = $phoneLand;
        $this->enabled2FA = $enabled2FA;
        $this->password = $password;
    }
}
