<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;
use LogicException;

/**
 * @internal
 */
class UpdateOrderTypeRequest
{
    public ?DateTimeImmutable $dueDate;
    public ?bool $visible;
    /**
     * @Serializer\SerializedName("cutoff_time")
     * @Serializer\Type("DateTimeImmutable<'H:i:s'>")
     */
    public ?DateTimeImmutable $cutOffTime;
    public ?int $workingDays;

    public function __construct(
        ?DateTimeImmutable $dueDate = null,
        ?bool $visible = null,
        ?DateTimeImmutable $cutOffTime = null,
        ?int $workingDays = null
    ) {
        $notNullParams = array_filter(
            [ $dueDate, $visible, $cutOffTime, $workingDays ],
            fn($param): bool => $param !== null
        );

        if (count($notNullParams) === 0) {
            throw new LogicException('You must provide at least one not-null parameter');
        }

        $this->dueDate = $dueDate;
        $this->visible = $visible;
        $this->cutOffTime = $cutOffTime;
        $this->workingDays = $workingDays;
    }
}
