<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Basket;

/**
 * @internal
 */
class ValidateRequest
{
    /** @var array<array<string,string|int>> */
    public array $items = [];
    public ?string $organisation = null;

    /**
     * @param array<array<string,string|int>> $items
     */
    public function __construct(array $items, ?string $organisation = null)
    {
        $this->items = $items;
        $this->organisation = $organisation;
    }
}
