<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Basket;

/**
 * @internal
 */
class ConfirmRequest
{
    public ?string $deliveryLocationId;
    public ?string $customerReference;
    /** @var array<string,string>|null */
    public ?array $deliveryLocation;
    public ?string $orderType;
    public ?string $amountPaid;

    /**
     * @param array<string,string>|null $newDeliveryLocation
     */
    public function __construct(
        ?string $deliveryLocationId,
        ?string $customerReference,
        ?array $newDeliveryLocation,
        ?string $orderType,
        ?string $amountPaid = null
    ) {
        $this->deliveryLocationId = $deliveryLocationId;
        $this->customerReference = $customerReference;
        $this->deliveryLocation = $newDeliveryLocation;
        $this->orderType = $orderType;
        $this->amountPaid = $amountPaid;
    }
}
