<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Auth;

/**
 * @internal
 */
class LoginRequest
{
    public string $clientId;
    public string $clientSecret;
    public string $email;
    public string $password;
    private ?string $role; // @phpstan-ignore-line

    public function __construct(string $clientId, string $clientSecret, string $email, string $password, ?string $role)
    {
        $this->clientId = $clientId;
        $this->clientSecret = $clientSecret;
        $this->email = $email;
        $this->password = $password;
        $this->role = $role;
    }
}
