<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class OrderItemResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $sku = null;
    /**
     * @Serializer\Type("int")
     */
    public int $quantity = 0;
    /**
     * @Serializer\Type("int")
     */
    public int $quantityDispatched = 0;
    /**
     * @Serializer\Type("string")
     */
    public ?string $status = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $unitPrice = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $tax;
    /**
     * @Serializer\Type("string")
     */
    public ?string $subtotal;
    /**
     * @Serializer\Type("string")
     */
    public ?string $total;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d', 'UTC'>")
     */
    public ?DateTimeImmutable $dispatched = null;
    /**
     * @var array<string,string>
     * @Serializer\Type("array<string, string>")
     */
    public ?array $productVariant = null;
}
