<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Invite;

/**
 * @internal
 */
class InviteRequest
{
    public string $firstName;
    public string $lastName;
    public ?string $jobTitle = null;
    public string $email;
    public string $url;

    public function __construct(
        string $firstName,
        string $lastName,
        ?string $jobTitle,
        string $email,
        string $url
    ) {
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->jobTitle = $jobTitle;
        $this->email = $email;
        $this->url = $url;
    }
}
