<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Product;

use JMS\Serializer\Annotation as Serializer;
use Rowlinson\Api\Responses\School\SchoolResponse;

class ProductResponse
{
    /**
     * The name of the product
     *
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * The alias / slug of the product
     *
     * @Serializer\Type("string")
     */
    public ?string $alias = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $description = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $longDescription = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $careInstructions = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $skuAlias = null;
    /**
     * Name of the product type
     *
     * @Serializer\Type("string")
     */
    public ?string $productType = null;
    /**
     * School (if any) the product belongs to
     *
     * @Serializer\Type("Rowlinson\Api\Responses\School\SchoolResponse")
     */
    public ?SchoolResponse $school = null;
    /**
     * Category this product is in
     *
     * @var array<mixed>
     * @Serializer\Type("array")
     */
    public array $categories = [];
    /**
     * @Serializer\Type("string")
     */
    public ?string $sizeGuide = null;
    /**
     * Product Variants
     *
     * @var array<mixed>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Product\ProductVariantResponse>")
     */
    public array $variants = [];
    /**
     * Media
     *
     * @Serializer\Type("Rowlinson\Api\Responses\Product\MediaResponse")
     */
    public ?MediaResponse $media = null;
}
