<?php

declare(strict_types=1);

namespace Rowlinson\Api;

use Rowlinson\Api\Requests\LeaversHoodies\PlaceLeaversHoodieRequest;
use Rowlinson\Api\Responses\LeaversHoodies\DownloadUrlResponse;
use Rowlinson\Api\Responses\LeaversHoodies\HoodieRequestResponse;

class LeaversHoodiesClient extends AbstractClient
{
    /**
     * @param array<string,string>|null $spreadsheet
     * @param array<string,string>|null $backDesignImage
     * @param array<string,string>|null $frontLeftEmbroideryImage
     */
    public function hoodieRequest(
        string $schoolName,
        ?string $schoolNameAlternative,
        string $orderReference,
        string $backDesignOption,
        string $frontLeftType,
        string $frontLeftNotes,
        string $frontRightChestOption,
        string $leftSleeveOption,
        string $hoodieColour,
        string $idealDate,
        string $deliveryAddress,
        string $downloadUrl,
        string $requestDate,
        ?array $spreadsheet = null,
        ?array $backDesignImage = null,
        ?array $frontLeftEmbroideryImage = null,
        ?string $notes = null
    ): HoodieRequestResponse {
        $response = $this->post('hoodies/request', new PlaceLeaversHoodieRequest(
            $schoolName,
            $schoolNameAlternative,
            $orderReference,
            $backDesignOption,
            $frontLeftType,
            $frontLeftNotes,
            $frontRightChestOption,
            $leftSleeveOption,
            $hoodieColour,
            $idealDate,
            $deliveryAddress,
            $downloadUrl,
            $requestDate,
            $spreadsheet,
            $backDesignImage,
            $frontLeftEmbroideryImage,
            $notes
        ));

        // @phpstan-ignore-next-line
        return $this->serializer->deserialize((string)$response->getBody(), HoodieRequestResponse::class, 'json');
    }

    public function fileRequest(string $path): DownloadUrlResponse
    {
        $response = $this->get("hoodies/download/$path");

        // @phpstan-ignore-next-line
        return $this->serializer->deserialize((string)$response->getBody(), DownloadUrlResponse::class, 'json');
    }
}
