<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Order;

/**
 * @internal
 */
class PlaceOrderRequest
{
    /** @var array<Item> */
    public array $items;
    public ?string $deliveryLocationId;
    public ?DeliveryLocation $deliveryLocation;
    public ?string $deliveryInstructions;
    public ?string $customerReference;
    public ?string $orderType;

    /**
     * @param array<Item> $items
     */
    public function __construct(
        array $items,
        ?string $deliveryLocationId,
        ?DeliveryLocation $deliveryLocation,
        ?string $deliveryInstructions,
        ?string $customerReference,
        ?string $orderType
    ) {
        $this->items = $items;
        $this->deliveryLocationId = $deliveryLocationId;
        $this->deliveryLocation = $deliveryLocation;
        $this->deliveryInstructions = $deliveryInstructions;
        $this->customerReference = $customerReference;
        $this->orderType = $orderType;
    }
}
