<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\LeaversHoodies;

class PlaceLeaversHoodieRequest
{
    public string $downloadUrl;
    public string $schoolName;
    public ?string $schoolNameAlternative;
    public string $orderReference;
    public string $backDesignOption;
    public string $frontLeftType;
    public string $frontLeftNotes;
    public string $frontRightChestOption;
    public string $leftSleeveOption;
    public string $hoodieColour;
    public string $idealDate;
    public string $requestDate;
    public string $deliveryAddress;
    public ?string $notes;

    /**
     * @var array<string,string>|null
     */
    public ?array $spreadsheet;

    /**
     * @var array<string,string>|null
     */
    public ?array $backDesignImage = null;

    /**
     * @var array<string,string>|null
     */
    public ?array $frontLeftEmbroideryImage = null;

    /**
     * @param array<string,string>|null $spreadsheet
     * @param array<string,string>|null $backDesignImage
     * @param array<string,string>|null $frontLeftEmbroideryImage
     */
    public function __construct(
        string $schoolName,
        ?string $schoolNameAlternative,
        string $orderReference,
        string $backDesignOption,
        string $frontLeftType,
        string $frontLeftNotes,
        string $frontRightChestOption,
        string $leftSleeveOption,
        string $hoodieColour,
        string $idealDate,
        string $deliveryAddress,
        string $downloadUrl,
        string $requestDate,
        ?array $spreadsheet = null,
        ?array $backDesignImage = null,
        ?array $frontLeftEmbroideryImage = null,
        ?string $notes = null
    ) {
        $this->schoolName = $schoolName;
        $this->schoolNameAlternative = $schoolNameAlternative;
        $this->orderReference = $orderReference;
        $this->backDesignOption = $backDesignOption;
        $this->frontLeftType = $frontLeftType;
        $this->frontLeftNotes = $frontLeftNotes;
        $this->frontRightChestOption = $frontRightChestOption;
        $this->leftSleeveOption = $leftSleeveOption;
        $this->hoodieColour = $hoodieColour;
        $this->idealDate = $idealDate;
        $this->deliveryAddress = $deliveryAddress;
        $this->downloadUrl = $downloadUrl;
        $this->requestDate = $requestDate;
        $this->spreadsheet = $spreadsheet;
        $this->backDesignImage = $backDesignImage;
        $this->frontLeftEmbroideryImage = $frontLeftEmbroideryImage;
        $this->notes = $notes;
    }
}
