<?php

declare(strict_types=1);

namespace Rowlinson\Api\Credentials;

class Credentials
{
    private string $clientKey;
    private string $clientSecret;
    private ApiKeyStorageInterface $apiKeyStorage;

    public function __construct(string $clientKey, string $clientSecret, ApiKeyStorageInterface $apiKeyStorage)
    {
        $this->clientKey = $clientKey;
        $this->clientSecret = $clientSecret;
        $this->apiKeyStorage = $apiKeyStorage;
    }

    public function getApiKey(): ?string
    {
        return $this->apiKeyStorage->retrieve();
    }

    public function setApiKey(string $apiKey): void
    {
        $this->apiKeyStorage->store($apiKey);
    }

    public function getClientKey(): string
    {
        return $this->clientKey;
    }

    public function getClientSecret(): string
    {
        return $this->clientSecret;
    }
}
