# CHANGELOG

## v0.11.1

### Non-breaking changes

* Added new method `Rowlinson\Api\ProductClient::getProductsWithHydratedStockAndSizes` that matches the `products_with_hydrated_stock_and_sizes` GET API endpoint to fetch products from the API database with additional data from the product service

## v0.11.0

### Breaking changes

* Removed the `organisation`, `sourceName`, and `recipientName` from the `placeOrder` method of the `OrderClient` class

## v0.10.9

### Non-breaking changes

* Added `taxExcludingDelivery` field to `Rowlinson\Api\Responses\Basket\BasketResponse`

## v0.10.8

### Non-breaking changes

* Created a new class `Rowlinson\Api\BankHolidayClient`
* Added new method `Rowlinson\Api\BankHolidaysClient::index` that matches the `bank_holiday` GET API endpoint to fetch bank holidays from the API database
* Added new method `Rowlinson\Api\BankHolidaysClient::create` that matches the `bank_holiday` POST API endpoint to update bank holidays in the API database

## v0.10.7

### Non-breaking changes

* New `delivery_options parameter when listing delivery locations specifying all the valid delivery options for that location
* New parameter for `getDeliveryOptions` on the `Rowlinson\Api\DeliveryLocationClient` to specify the order type

## v0.10.6

### Non-breaking changes

* Added new `validForCountries` property to `Rowlinson\Api\Responses\DeliveryLocation\DeliveryLocationResponse`
* Added new `subtotalExcludingDelivery` property to `Rowlinson\Api\Responses\Basket\BasketResponse` 

## v0.10.5

### Non-breaking changes

* Updated method `Rowlinson\Api\UserClient::feedback` to accept new required parameter `unique_id`
* Updated `Rowlinson\Api\Requests\User\FeedbackRequest` to handle required string parameter `unique_id`

## v0.10.4

### Non-breaking changes

* Updated `Rowlinson\Api\OrderClient::getOrders` with optional new parameters `sortBy` and `sortDir` to sort orders in the response
* Created new methods `Rowlinson\Api\Responses\ApiResponse::getSortedBy` and `Rowlinson\Api\Responses\ApiResponse::getSortDirection` to handle new response headings
* Added new `Rowlinson\Api\Collections\SortedPaginatedCollection`

## v0.10.3

### Non-breaking changes

* Added new method `Rowlinson\Api\UserClient::feedback` that matches the `user/feedback` POST API endpoint to submit user feedback

## v0.10.2

### Non-breaking changes

* Updated `Rowlinson\Api\OrderClient::exportOrders` with optional new parameter `orderTypes` to filter orders included in the export by order type
* Updated `Rowlinson\Api\OrderClient::getOrderTypes` with optional new parameter `historical` to return all order types a customer has in their order history

## v0.10.1

### Non-breaking changes

* Added new method `Rowlinson\Api\DeliveryLocationClient::remove` that matches the `delivery-location` DELETE API endpoint to soft-delete a delivery location

## v0.10.0

### Breaking changes

* Changed the format of the `school` field of `Rowlinson\Api\Responses\Product\ProductResponse` to a `Rowlinson\Api\Responses\School\SchoolResponse` - so the alias is included and can be used for breadcrumb routing
* Added `serializerHandlers` static method to `Sdk` for configuring custom JMS serializer types

## v0.9.0

### Breaking changes

* Updated PHP version to 8.2, added support for Laravel version 10

## v0.8.7

### Non-breaking changes

* Created a new class `Rowlinson\Api\SchoolClient`
* Created a new method `Rowlinson\Api\SchoolClient::getSchools` that matches the `schools` GET API endpoint to fetch all of a customer's associated schools
* Updated `Rowlinson\Api\ProductClient::getProducts` with a new parameter `schoolAlias` for fetching products of a particular school
* Updated `Rowlinson\Api\ProductClient::getProductCount` with a new parameter `schoolAlias` for fetching the number of products associated with a particular school
* Created a new method `Rowlinsons\Api\Sdk::getSchool` to fetch the SchoolClient API client

## v0.8.6

### Non-breaking changes

* Added `typeName` field to `Rowlinson\Api\Responses\Order\OrderResponse` and `Rowlinson\Api\Responses\Order\OrdersResponse`

## v0.8.5

### Non-breaking changes

* Added new method `Rowlinson\Api\OrderClient::split` that matches the `orders/split` POST API endpoint for admins to test order splitting

## v0.8.4

### Non-breaking changes

* Added `Accept: application/json` to `AbstractClient::request` method to ensure that any responses from the API are JSON formatted, this only really matters when the API uses form validation as well as JSON schema validation

## v0.8.3

### Non-breaking changes

* Created a new class `Rowlinson\Api\LeaversHoodiesClient`
* Added new method `Rowlinson\Api\LeaversHoodiesClient::hoodieRequest` that matches the `hoodies/request` POST API endpoint to create a new Leavers Hoodie request
* Added new method `Rowlinson\Api\LeaversHoodiesClient::fileRequest` that matches the `hoodies/download/{path}` GET API endpoint to download an asset from a previous Leavers Hoodie request (Spreadsheet or Design file for example)

## v0.8.2

### Non-breaking changes

* Added new method `Rowlinson\Api\BasketClient::removeBasket` that matches the `basket` DELETE API endpoint to clear the currently logged in user's basket in its entirety

## v0.8.1

### Non-breaking changes

* Added new method `Rowlinson\Api\BasketClient::addManyToBasket` that matches the `basket/add_items` POST API endpoint for adding many items to the currently logged in user's basket at once

## v0.8.0

### Breaking changes

* Changed the name of the `totalPrice` field of `Rowlinson\Api\Responses\Basket\ItemResponse` to `total` - this now matches what the API field name is as well as the `Rowlinson\Api\Responses\Basket\BasketResponse` field is named
* Changed the name of the `surchargeWarnings` field of `Rowlinson\Api\Responses\Basket\BasketResponse` to `surcharges` which is now an array of `Rowlinson\Api\Responses\Basket\SurchargeResponse`

### Non-breaking changes

* Added `subtotal`, `created` and `updated` fields to `Rowlinson\Api\Responses\Basket\ItemResponse`
* Added `subtotalExcludingSurcharges`, `orderType`, `deliveryOption`, `deliveryPrice`, `deliveryTax`, `freeDeliveryEligible` and `amountUntilFreeDelivery` to `Rowlinson\Api\Responses\Basket\BasketResponse`
* Added `unitPrice`, `tax`, `subtotal`, and `total` fields to `Rowlinson\Api\Responses\Order\OrderItemResponse`
* Added `subtotal`, `tax`, `total` fields to `Rowlinson\Api\Responses\Order\OrderResponse`
* Added new method `Rowlinson\Api\DeliveryLocationClient::getDeliveryOptions()` that matches the `delivery_options` API endpoint, returns an array of `Rowlinson\Api\Responses\DeliveryLocation\DeliveryOptionResponse`
* Added new method `Rowlinson\Api\BasketClient::setDeliveryOption()` that matches the `basket/delivery/{optionId}` API endpoint for updating the delivery option of the current basket
* Added new method `Rowlinson\Api\BasketClient::setOrderType()` that matches the `basket/order_type` PUT API endpoint for updating the order type of the current basket
* `Rowlinson\Api\AbstractClient` can now throw a `Rowlinson\Api\Exceptions\PricingServiceUnavailableException` if receiving an HTTP 503 with an X-Pricing-Unavailable header

## v0.7.3

### Non-breaking changes

* Added `status` property to `Rowlinson\Api\Responses\Order\OrderItemResponse`

## v0.7.2

### Non-breaking changes

* Added `quantityDispatched` property to `Rowlinson\Api\Responses\Order\OrderItemResponse`

## v0.7.1

### Non-breaking changes

* Added a new property to product variants - `stockDueDate` - if not null it indicates when new stock is expected for that variant

## v0.7.0

### Breaking changes

* Changed the media response on a product to now be a multi-stage array. Originally this looked like:

```php
[ 'images' => [ [ 'width' => 123, 'height' => '456', 'url' => 'https://...' ] ]
```

Now it is:

```php
[ 'images' => [ 'MAROON' => [ '123x456' => [ 'image/jpeg' => 'https://...', 'image/webp' => 'https://...' ] ] ]
```

This will be available both when searching for products and when viewing a single product.

## v0.6.2

### Non-breaking changes

* Added a new property to product variants - `stockLevel` - indicates the current stock level for that variant

## v0.6.1

### Non-breaking changes

* Added a new method `Rowlinson\Api\BasketClient::addBasketItemsFromOrder()` that matches the `basket/add_order/{orderNumber}` API endpoint that populates the basket with available items from the supplied order.

## v0.6.0

### Breaking changes

* Added a new required parameter - `?string $type` to the `Rowlinson\Api\OrderClient::exportOrders` method to enable generating detailed and summary sales reports, the signature is now `DateTimeImmutable $start, DateTimeImmutable $finish, string $type`

## v0.5.1

### Non-breaking changes

* Added a new method `Rowlinson\Api\OrderClient::exportOrders()` that matches the `orders/export` API endpoint that requests a CSV export of orders from the supplied date range 

## v0.5.0

### Breaking changes

* Added a new required parameter - `?string $orderType` to the `Rowlinson\Api\OrderClient::placeOrder()` method, the signature is now `array $items, ?string $deliveryLocationId, ?DeliveryLocation $newDeliveryLocation, ?string $organisation, ?string $recipientName, ?string $deliveryInstructions, ?string $customerReference, ?string $sourceName, ?string $orderType`
* Added a new required parameter - `?string $orderType` to the `Rowlinson\Api\BasketClient::confirm()` method, the signature is now `?string $deliveryLocationId, ?string $customerReference, ?string $deliveryInstructions, ?array $newDeliveryLocation, ?string $orderType`

### Non-breaking changes

* Created a new method `Rowlinson\Api\OrderClient::getOrderTypes()` that matches the `orders/types` API endpoint which returns the forward order types available for the currently authenticated user, or if the authenticated user is an admin, they can pass `all` and see all order types
* Created a new method `Rowlinson\Api\OrderClient::updateOrderType()` that matches the `orders/types/{orderType}` API endpoint which allows admin users to update the customer visibility, due date, cut-off time and how many working days production takes for order types

## v0.4.2

### Non-breaking changes

* Added a new optional parameter - `?bool $approvedVariants` to the `Rowlinson\Api\ProductClient::getProduct()` method for fetching only approved or unapproved variants, `null` will return both - the old and default behaviour

## v0.4.1

### Breaking changes

* Added a new required parameter - `?string $sourceName` to the `Rowlinson\Api\OrderClient::placeOrder()` method, the signature is now `array $items, ?string $deliveryLocationId, ?DeliveryLocation $newDeliveryLocation, ?string $organisation, ?string $recipientName, ?string $deliveryInstructions, ?string $customerReference, ?string $sourceName`
* Added a new required parameter - `?string $sourceName` to the `Rowlinson\Api\Requests\Order\PlaceOrderRequest` method, the signature is now `array $items, ?string $deliveryLocationId, ?DeliveryLocation $newDeliveryLocation, ?string $organisation, ?string $recipientName, ?string $deliveryInstructions, ?string $customerReference, ?string $sourceName`

## v0.4

### Breaking changes

* Moved and renamed current method `Rowlinson\Api\OrderClient::placeOrder()` to `Rowlinson\Api\BasketClient::confirm()` to correctly match its API category + function
* Created a new method `Rowlinson\Api\OrderClient::placeOrder()` that matches the `orders/place` API endpoint which places an order using passed values rather than the current basket

All classes within the `Rowlinson\Api\Requests` namespace are marked as `@internal` so you shouldn't be using these classes in your own code, however:

* Moved and renamed current class `Rowlinson\Api\Requests\Order\PlaceOrderRequest` to `Rowlinson\Api\Requests\Basket\ConfirmRequest` to match the method move
* Created a new class `Rowlinson\Api\Requests\Order\PlaceOrderRequest` to be used with the new `placeOrder` method,

### Non-breaking changes

* Added a new class `Rowlinson\Api\Requests\Order\DeliveryLocation` for new Delivery locations when placing an order, this is not marked as `@internal` and should be used in consumer code
* Added a new class `Rowlinson\Api\Requests\Order\Item` for basket items when placing an order, this is not marked as `@internal`

## v0.3.3

### Non-breaking changes

* Added an `invoiceAddress` property to `Rowlinson\Api\Responses\Organisation\OrganisationResponse`
* Added a `gln` property to `Rowlinson\Api\Responses\DeliveryLocation\DeliveryLocationResponse`

## v0.3.2

### Non-breaking changes

* Added a new method Rowlinson\Api\OrganisationClient::getContacts which will retrieve the contacts for an organisation (admin role users only)
* Added a new response class Rowlinson\Api\Responses\Organisation\ContactResponse for an organisation's contacts

## v0.3.1

### Non-breaking changes

* Rowlinson\Api\BasketClient::validate now correctly catches the 400 (Bad Request) response code that the API returns if the basket under validation has errors, before an exception would have been thrown

## v0.3

### Breaking changes

* Removed the `vatRate` property from `Rowlinson\Api\Responses\Product\ProductVariantResponse`, this property is now called `tax`

### Non-breaking changes

* Added `skuAlias`, `sortCode` and `totalPrice` properties to `Rowlinson\Api\Responses\Product\ProductVariantResponse`

## v0.2.1

### Non-breaking changes

* Added a new parameter to `Rowlinson\Api\ProductClient::getProducts()`, the method signature is now `int $page = 1, ?string $categoryId = null, array $skus = [], array $types = [], bool $includeVariants = false, ?string $organisationAlias = null`, this allows passing an organisation alias that will return that organisation's products if the authenticated user is an admin
* Added a new parameter to `Rowlinson\Api\ProductClient::getProductCount()`, the method signature is now `?string $categoryId = null, array $skus = [], array $types = [], ?string $organisationAlias = null` and allows for the same functionality as `getProducts()` above

## v0.2

### Breaking changes

* Moved the following methods from `Rowlinson\Api\UserClient` to `Rowlinson\Api\AuthClient`:
    - `login`
    - `logout`
    - `verify`
    - `verifyCredentials`
    - `impersonate`
    - `setApiKey`
* Moved the following methods from `Rowlinson\Api\UserClient` to `Rowlinson\Api\InviteClient`:
    - `invite`
    - `getInvite`
    - `resendInvite`
* Added a new parameter to `Rowlinson\Api\DeliveryLocationClient::getDeliveryLocations()`, the method signature used to be `int $page = 1, int $perPage = 10`, the new signature is `string $organisation = null, int $page = 1, int $perPage = 10`
* Moved `Rowlinson\Api\Responses\User\LoginResponse` to `Rowlinson\Api\Responses\Auth\LoginResponse`
* Moved `Rowlinson\Api\Responses\User\GetInviteResponse` to `Rowlinson\Api\Responses\Invites\GetInviteResponse`
* Moved `Rowlinson\Api\Requests\User\InviteRequest` to `Rowlinson\Api\Requests\Invite\InviteRequest`
* Moved `Rowlinson\Api\Requests\User\{ImpersonateRequest,LoginRequest,VerifyCredentialsRequest,VerifyRequest}` to `Rowlinson\Api\Requests\Auth` namespace

### Non-breaking changes

* Added a new method `Rowlinson\Api\AuthClient::sso()` to exchange an SSO token for an API key
* Added a new method `Rowlinson\Api\BasketClient::validate()` to send a collection of product variants with an optional organisation alias and receive errors and surcharge warnings back
* Added a new client `Rowlinson\Api\OrganisationClient` for fetching information about organisations, this is fetchable via the `createOrganisation()` method on `Rowlinson\Api\Sdk`
