<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class OrderTypeResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $alias = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z'>")
     */
    public ?DateTimeImmutable $dueDate = null;
    /**
     * @Serializer\SerializedName("is_visible")
     * @Serializer\Type("boolean")
     */
    public ?bool $visible = null;
    /**
     * @Serializer\SerializedName("cutoff_time")
     * @Serializer\Type("DateTimeImmutable<'H:i:s'>")
     */
    public ?DateTimeImmutable $cutOffTime = null;
    /**
     * @Serializer\Type("int")
     */
    public ?int $workingDays = null;
    /**
     * @Serializer\SerializedName("is_day_to_day")
     * @Serializer\Type("boolean")
     */
    public ?bool $dayToDay = null;
}
