<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\DeliveryLocation;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class DeliveryLocationResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $id = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("address_line_1")
     */
    public ?string $addressLine1 = null;
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("address_line_2")
     */
    public ?string $addressLine2 = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $town = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $county = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $country = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $postcode = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $gln = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\\TH:i:sP', 'UTC'>")
     */
    public ?DateTimeImmutable $createdAt = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\\TH:i:sP', 'UTC'>")
     */
    public ?DateTimeImmutable $updatedAt = null;
    /**
     * @var array<DeliveryOptionResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\DeliveryLocation\DeliveryOptionResponse>")
     * @Serializer\SerializedName("delivery_options")
     */
    public array $deliveryOptions = [];
}
