<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Product;

use JMS\Serializer\Annotation as Serializer;

class MediaResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $embed = null;
    /**
     * Top level key is the colour, e.g. MAROON, second level key is the size e.g. 123x456, third level key is the mime
     * type e.g. image/png
     *
     * [ 'MAROON' => [ '123x456' => [ 'image/png' => 'url', 'image/jpeg' => 'url' ] ] ]
     *
     * @var array<string,array<string,array<string,string>>>
     * @Serializer\Type("array<string,array<string,array<string,string>>>")
     */
    public array $images = [];
}
