<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Order;

/**
 * @internal
 */
class PlaceOrderRequest
{
    /** @var array<Item> */
    public array $items;
    public ?string $organisation;
    public ?string $deliveryLocationId;
    public ?DeliveryLocation $deliveryLocation;
    public ?string $deliveryInstructions;
    public ?string $customerReference;
    public ?string $recipientName;
    public ?string $sourceName;
    public ?string $orderType;

    /**
     * @param array<Item> $items
     */
    public function __construct(
        array $items,
        ?string $organisation,
        ?string $deliveryLocationId,
        ?DeliveryLocation $deliveryLocation,
        ?string $deliveryInstructions,
        ?string $customerReference,
        ?string $recipientName,
        ?string $sourceName,
        ?string $orderType
    ) {
        $this->items = $items;
        $this->organisation = $organisation;
        $this->deliveryLocationId = $deliveryLocationId;
        $this->deliveryLocation = $deliveryLocation;
        $this->deliveryInstructions = $deliveryInstructions;
        $this->customerReference = $customerReference;
        $this->recipientName = $recipientName;
        $this->sourceName = $sourceName;
        $this->orderType = $orderType;
    }
}
