<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Basket;

/**
 * @internal
 */
class ConfirmRequest
{
    public ?string $deliveryLocationId;
    public ?string $customerReference;
    public ?string $deliveryInstructions;
    /** @var array<string,string>|null */
    public ?array $deliveryLocation;
    public ?string $orderType;

    /**
     * @param array<string,string>|null $newDeliveryLocation
     */
    public function __construct(
        ?string $deliveryLocationId,
        ?string $customerReference,
        ?string $deliveryInstructions,
        ?array $newDeliveryLocation,
        ?string $orderType
    ) {
        $this->deliveryLocationId = $deliveryLocationId;
        $this->customerReference = $customerReference;
        $this->deliveryInstructions = $deliveryInstructions;
        $this->deliveryLocation = $newDeliveryLocation;
        $this->orderType = $orderType;
    }
}
