<?php

declare(strict_types=1);

namespace Rowlinson\Api;

use Rowlinson\Api\Collections\PaginatedCollection;
use Rowlinson\Api\Responses\Organisation\ContactResponse;
use Rowlinson\Api\Responses\Organisation\OrganisationResponse;

class OrganisationClient extends AbstractClient
{
    /**
     * List all the organisations
     *
     * @return PaginatedCollection<OrganisationResponse>
     */
    public function getOrganisations(int $page = 1): PaginatedCollection
    {
        $response = $this->get('organisations?' . http_build_query([
            'page' => $page,
        ]));

        $organisations = $this->serializer->deserialize(
            (string)$response->getBody(),
            'array<' . OrganisationResponse::class . '>',
            'json'
        );

        return new PaginatedCollection(
            $organisations,
            $page,
            $response->getPaginationPerPage(),
            $response->getPaginationTotalItems()
        );
    }

    /**
     * @return PaginatedCollection<ContactResponse>
     */
    public function getContacts(string $organisationAlias): PaginatedCollection
    {
        $response = $this->get('organisations/' . $organisationAlias . '/contacts');

        $contacts = $this->serializer->deserialize(
            (string)$response->getBody(),
            'array<' . ContactResponse::class . '>',
            'json'
        );

        // @phpstan-ignore-next-line
        return new PaginatedCollection($contacts, 1, max(count($contacts), 1), count($contacts));
    }
}
