<?php

declare(strict_types=1);

namespace Rowlinson\Api;

use Rowlinson\Api\Responses\BankHolidays\BankHolidaysResponse;

class BankHolidaysClient extends AbstractClient
{
    /**
     * Fetches the most recently updated bank holiday data
     */
    public function index(): BankHolidaysResponse
    {
        $response = $this->get('bank_holidays');

        /** @var BankHolidaysResponse */
        return $this->serializer->deserialize(
            (string)$response->getBody(),
            BankHolidaysResponse::class,
            'json'
        );
    }

    /**
     * Request the creation of a new bank holidays record
     */
    public function create(
        string $bankHolidayJson
    ): void {
        $this->post('bank_holidays', json_decode($bankHolidayJson));
    }
}
