<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;
use Rowlinson\Api\Responses\DeliveryLocation\DeliveryLocationResponse;

class OrderResponse
{
    /**
     * The ID / order number of this order
     *
     * @Serializer\Type("string")
     */
    public ?string $id = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z'>")
     */
    public ?DateTimeImmutable $created = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z'>")
     */
    public ?DateTimeImmutable $updated = null;
    /**
     * The number of items in this order
     *
     * @Serializer\Type("int")
     */
    public int $itemCount = 0;
    /**
     * The delivery location for this order
     *
     * @Serializer\Type("Rowlinson\Api\Responses\DeliveryLocation\DeliveryLocationResponse")
     */
    public ?DeliveryLocationResponse $deliveryLocation = null;
    /**
     * Customer reference, if any
     *
     * @Serializer\Type("string")
     */
    public ?string $customerReference = null;
    /**
     * The status of this order e.g. "pending", "dispatched"
     *
     * @Serializer\Type("string")
     */
    public ?string $status;
    /**
     * The items comprising this order
     *
     * @var array<OrderItemResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Order\OrderItemResponse>")
     */
    public array $items = [];
    /**
     * The subtotal (excluding tax) of all the items on the order
     *
     * @Serializer\Type("string")
     */
    public string $subtotal;
    /**
     * The total tax of all the items on the order
     *
     * @Serializer\Type("string")
     */
    public string $tax;
    /**
     * The subtotal + tax of all the items on the order
     *
     * @Serializer\Type("string")
     */
    public string $total;
    /**
     * The order type name, used in My Account for past orders
     *
     * @Serializer\Type("string")
     */
    public ?string $typeName = null;
}
