<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\DeliveryLocation;

use JMS\Serializer\Annotation as Serializer;

class DeliveryOptionResponse
{
    /**
     * The ID of this delivery option
     *
     * @Serializer\Type("string")
     */
    public ?string $id = null;
    /** @Serializer\Type("string") */
    public ?string $name = null;
    /** @Serializer\Type("string") */
    public ?string $alias = null;
    /** @Serializer\Type("string") */
    public ?string $price = null;
    /**
     * @var array<string> $validForCountries
     * @Serializer\Type("array")
     */
    public ?array $validForCountries = null;
}
