<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Auth;

use JMS\Serializer\Annotation as Serializer;

class LoginResponse
{
    /**
     * On a successful login, this will be the API key to use for subsequent API requests
     *
     * @Serializer\Type("string")
     */
    public ?string $apiKey = null;
    /**
     * If a login requires 2FA, this will be the string "2FA verification required"
     *
     * @Serializer\Type("string")
     */
    public ?string $description = null;
    /**
     * If a login requires 2FA, this will be the challenge ID to use when entering the 2FA value on a subsequent request
     *
     * @Serializer\Type("string")
     */
    public ?string $challengeId = null;

    /**
     * Whether this login response indicates that 2FA is required
     */
    public function requires2FA(): bool
    {
        return !empty($this->description) && !empty($this->challengeId);
    }
}
