<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\User;

use JMS\Serializer\Annotation as Serializer;

/**
 * @internal
 */
class FeedbackRequest
{
    /**
     * @Serializer\SerializedName("star_rating")
     * @Serializer\Type("int")
     */
    public int $star_rating;

    /**
     * @Serializer\SerializedName("unique_id")
     * @Serializer\Type("string")
     */
    public string $unique_id;

    /**
     * @Serializer\SerializedName("feedback")
     * @Serializer\Type("string")
     */
    public ?string $feedback;

    public function __construct(int $rating, string $uniqueId, ?string $feedback)
    {
        $this->star_rating = $rating;
        $this->unique_id = $uniqueId;
        $this->feedback = $feedback;
    }
}
