<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Auth;

use JMS\Serializer\Annotation as Serializer;

/**
 * @internal
 */
class VerifyRequest
{
    public string $clientId;
    public string $clientSecret;
    public string $challengeId;
    /**
     * @Serializer\SerializedName("2fa_token")
     * @Serializer\Type("int")
     */
    public int $token;

    public function __construct(string $clientId, string $clientSecret, string $challengeId, string $token)
    {
        $this->clientId = $clientId;
        $this->clientSecret = $clientSecret;
        $this->challengeId = $challengeId;
        $this->token = intval($token);
    }
}
