<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class OrdersResponse
{
    /**
     * The ID / Order number of this order
     *
     * @Serializer\Type("string")
     */
    public ?string $id = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z'>")
     */
    public ?DateTimeImmutable $created = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z'>")
     */
    public ?DateTimeImmutable $updated = null;
    /**
     * The customer reference (if any)
     *
     * @Serializer\Type("string")
     */
    public ?string $customerReference = null;
    /**
     * The status of the order e.g. "processing", "pending"
     *
     * @Serializer\Type("string")
     */
    public ?string $status = null;
    /**
     * The order type name, used in My Account for past orders
     *
     * @Serializer\Type("string")
     */
    public ?string $typeName = null;
    /**
     * The user who placed the order
     *
     * @Serializer\Type("Rowlinson\Api\Responses\Order\OrderUserResponse")
     */
    public ?OrderUserResponse $user = null;
}
