<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Basket;

use JMS\Serializer\Annotation as Serializer;
use Rowlinson\Api\Responses\Order\OrderItemResponse;

class AddFromOrderResponse
{
    /**
     * @Serializer\Type("bool")
     */
    public bool $success = false;
    /**
     * @Serializer\Type("string")
     */
    public ?string $description = null;
    /**
     * @var array<OrderItemResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Order\OrderItemResponse>")
     */
    public array $unavailable = [];
}
