<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\DeliveryLocation;

use JMS\Serializer\Annotation as Serializer;

/**
 * @internal
 */
class CreateUpdateRequest
{
    public string $name;
    /**
     * @Serializer\SerializedName("address_line_1")
     * @Serializer\Type("string")
     */
    public string $addressLine1;
    /**
     * @Serializer\SerializedName("address_line_2")
     * @Serializer\Type("string")
     */
    public ?string $addressLine2;
    public string $town;
    public ?string $county;
    public string $postcode;
    public string $country;

    public function __construct(
        string $name,
        string $addressLine1,
        ?string $addressLine2,
        string $town,
        ?string $county,
        string $postcode,
        string $country
    ) {
        $this->name = $name;
        $this->addressLine1 = $addressLine1;
        $this->addressLine2 = $addressLine2;
        $this->town = $town;
        $this->county = $county;
        $this->postcode = $postcode;
        $this->country = $country;
    }
}
