<?php

declare(strict_types=1);

namespace Rowlinson\Api\Credentials;

class InMemoryApiKeyStorage implements ApiKeyStorageInterface
{
    private ?string $apiKey = null;

    /**
     * {@inheritDoc}
     */
    public function store(string $apiKey): void
    {
        $this->apiKey = $apiKey;
    }

    /**
     * {@inheritDoc}
     */
    public function retrieve(): ?string
    {
        return $this->apiKey;
    }
}
