<?php

declare(strict_types=1);

namespace Rowlinson\Api;

use Rowlinson\Api\Responses\School\SchoolResponse;

class SchoolClient extends AbstractClient
{
    /**
     * Get the schools associated with the currently logged in customer
     *
     * @return array<SchoolResponse>
     */
    public function getSchools(): array
    {
        $response = $this->get('schools');

        /** @var array<SchoolResponse> */
        return $this->serializer->deserialize(
            (string)$response->getBody(),
            'array<' . SchoolResponse::class . '>',
            'json'
        );
    }
}
