<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Product;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class ProductVariantResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $sku = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $skuAlias = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $sortCode = null;
    /**
     * @var array<string, string>
     * @Serializer\Type("array<string, string>")
     */
    public array $options = [];
    /**
     * @Serializer\Type("string")
     */
    public ?string $unitPrice = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $tax = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $totalPrice = null;
    /**
     * @Serializer\Type("int")
     */
    public ?int $stockLevel = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d'>")
     */
    public ?DateTimeImmutable $stockDueDate = null;
}
