<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Product;

use JMS\Serializer\Annotation as Serializer;

class ProductCategoryResponse
{
    /**
     * The ID of the product category
     *
     * @Serializer\Type("string")
     */
    public ?string $id = null;
    /**
     * Name of the product category
     *
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * Text describing the product category
     *
     * @Serializer\Type("string")
     */
    public ?string $description = null;
    /**
     * A short slug representing the product category
     *
     * @Serializer\Type("string")
     */
    public ?string $alias = null;
    /**
     * A URL for the thumbnail image of the current product category
     *
     * @Serializer\Type("string")
     */
    public ?string $thumbnailImage = null;
    /**
     * Sub categories
     *
     * @var array<ProductCategoryResponse>
     * @Serializer\Type("array<Rowlinson\Api\Responses\Product\ProductCategoryResponse>")
     */
    public array $children = [];
}
