<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Organisation;

use JMS\Serializer\Annotation as Serializer;
use Rowlinson\Api\Responses\DeliveryLocation\DeliveryLocationResponse;

class OrganisationResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $alias = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $orderPrefix = null;
    /**
     * @Serializer\SerializedName("invoice_address")
     */
    public ?DeliveryLocationResponse $invoiceAddress = null;
}
