<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Basket;

use JMS\Serializer\Annotation as Serializer;

class SurchargeResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $name = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $description = null;
    /**
     * @var array<string>
     * @Serializer\Type("array<string>")
     * @Serializer\SerializedName("basket_items")
     */
    public array $skus = [];
    /**
     * @Serializer\Type("string")
     */
    public ?string $price = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $tax = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $total = null;
}
