<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\Basket;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class ItemResponse
{
    /**
     * @Serializer\Type("string")
     */
    public ?string $sku = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $unitPrice = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $subtotal = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $tax = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $total = null;
    /**
     * @Serializer\Type("int")
     */
    public int $quantity = 1;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z', 'UTC'>")
     */
    public ?DateTimeImmutable $created = null;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d\TH:i:s.u\Z', 'UTC'>")
     */
    public ?DateTimeImmutable $updated = null;
}
