<?php

declare(strict_types=1);

namespace Rowlinson\Api\Responses\User;

use JMS\Serializer\Annotation as Serializer;

class ListAllSingleResponse
{
    /**
     * Mr, Mrs, Professor etc.
     *
     * @Serializer\Type("string")
     */
    public ?string $title = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $firstName = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $lastName = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $email = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $phoneMobile = null;
    /**
     * @Serializer\Type("string")
     */
    public ?string $jobTitle = null;
    /**
     * @Serializer\Type("bool")
     * @Serializer\SerializedName("enabled_2fa")
     */
    public bool $enabled2FA = false;
}
