<?php

declare(strict_types=1);

namespace Rowlinson\Api\Requests\Order;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

class ExportOrdersRequest
{
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d'>")
     */
    public DateTimeImmutable $start;
    /**
     * @Serializer\Type("DateTimeImmutable<'Y-m-d'>")
     */
    public DateTimeImmutable $finish;
    public string $type;
    /**
     * @var array<string>|null $orderTypes
     * @Serializer\Type("array<string>|null")
     */
    public ?array $orderTypes;

    /**
     * @param array<string>|null $orderTypes
     * @Serializer\Type("array<string>|null")
     */
    public function __construct(DateTimeImmutable $start, DateTimeImmutable $finish, string $type, ?array $orderTypes)
    {
        $this->start = $start;
        $this->finish = $finish;
        $this->type = $type;
        $this->orderTypes = $orderTypes;
    }
}
