<?php

namespace learntotrade\salesforce;

use GuzzleHttp\RequestOptions;
use learntotrade\salesforce\Exceptions\SalesforceException;
use learntotrade\salesforce\fields\SaleInvoiceFields;

class SaleInvoice extends SalesforceObject
{
    protected $name = 'Sale_Invoices__c';

    /**
     * Fetches a list of subscription invoices associated with the passed in subscription id(s)
     * @param  array  $saleIds
     * @return array
     */
    public function findBySale($saleIds = []) : array
    {
        $query = 'SELECT Id, ' . SaleInvoiceFields::SALE . ' FROM Sale_Invoices__c';
        $query .= ' WHERE ' . SaleInvoiceFields::SALE . ' IN (\'' . implode('\',\'', $saleIds) . '\')';
        try {
            $response = $this->client->request()->get($this->queryResource, [
                RequestOptions::HEADERS => $this->headers(),
                RequestOptions::QUERY => [
                    'q' => $query
                ]
            ]);
            $sales = json_decode($response->getBody(), true)['records'] ?? [];
        } catch (\Exception $exception) {
            throw new SalesforceException(
                'Unable to retrieve invoices by subscrition from Salesforce'
                . ' Salesforce object: ' . $exception->getMessage()
                . ' SOQL: ' . $query
            );
        }

        return $sales;
    }
}
