<?php

namespace learntotrade\salesforce\fields;

class UserFields
{
    /**
     * User first name
     */
    const FIRST_NAME = 'FirstName';

    /**
     * User last name
     */
    const LAST_NAME = 'LastName';

    /**
     * User's email address
     */
    const EMAIL = 'Email';

    /**
     * User's avatar URL
     */
    const AVATAR = 'UK_Speaker_Image__c';

    /**
     * Text about user.
     */
    const BIO = 'AboutMe';

    /**
     * User's region - e.g. 'UK'
     */
    const REGION = 'Region__c';

    /**
     * User's experience - e.g. '7 years'
     */
    const EXPERIENCE = 'Experience__c';

    /**
     * User's experience summary
     */
    const EXPERIENCE_SUMMARY = 'Experience_Summary__c';

    /**
     * Market Traded
     */
    const MARKET_TRADED = 'Market_Traded__c';

    /**
     *  Market Traded Summary
     */
    const MARKET_TRADED_SUMMARY = 'Market_Traded_Summary__c';

    /**
     * Coach audience ('SmartCharts', LTT, or both)
     */
    const BUSINESS_DIVISION = 'Business_Division__c';

    /**
     * User's role [coach, null, etc]
     */
    const BUSINESS_ROLE = 'Business_Role__c';

    /**
     * Languages
     */
    const LANGUAGES = 'Coach_Languages_Spoken__c';

    /**
     * Trading Style
     */
    const TRADING_STYLE = 'Coach_Trading_Style__c';

    /**
     * Trading Style Summary
     */
    const TRADING_STYLE_SUMMARY = 'Trading_Style_Summary__c';

    /**
     * Coach image URL
     */
    const COACH_IMAGE = 'Coach_Image__c';

    /**
     * Coach Country
     */
    const COACH_COUNTRY = 'Coach_Country__c';

    /**
     *  Can Coach Frontend
     */
    const CAN_COACH_FRONT_END = 'Coach_Front_End__c';

    /**
     *  Can Coach Backend
     */
    const CAN_COACH_BACK_END = 'Coach_Back_End__c';

    /**
     *  Coach Assigned Region
     */
    const COACH_ASSIGNED_REGION = 'Coach_Assigned_Region__c';

    /**
     *  Coach TimeZone
     */
    const COACH_TIME_ZONE = 'TimeZone__c';

    /**
     *  Coach Time Zone
     */
    const COACH_TIME_ZONE_SID_KEY = 'TimeZoneSidKey';

    /**
     *  Coach is Active
     */
    const COACH_IS_ACTIVE = 'IsActive';

}
