<?php

namespace learntotrade\salesforce\fields;

class SubscriptionFields
{
    /**
     * Reference to associated person account
     */
    const PERSON = 'Account__c';

    /**
     * Status of the subscription
     */
    const STATUS = 'Status__c';

    /**
     * Date of cancellation, the status should come back with 'Cancelled' once this has been set
     */
    const CANCELLED_DATE = 'Cancelled_Date__c';

    /**
     * The date of when the status was set to 'pending cancellation'.
     */
    const PENDING_CANCELLATION_DATE = 'pending_cancelled_date__c';

    /**
     * Foreign key to Purchase Option
     */
    const PURCHASE_OPTION = 'Purchase_Option__c';

    /**
     * Foreign key to Combi Product
     */
    const COMBI_PRODUCT = 'Combi_Product__c';

    /**
     * Product status of the subscription
     *
     * - Subscribed
     * - Upgrade
     * - Teaser
     */
    const PRODUCT_STATUS = 'Combi_product_status__c';

    /**
     * Subscription message to show to customer - e.g. sales text relating to a teaser
     */
    const MESSAGE = 'Combi_Product_Message__c';

    /**
     * The price to pay per period for this subscription
     */
    const RECURRING_AMOUNT = 'Monthly_Amount__c';

    /**
     * Status of syncing data from salesforce to chargebee
     */
    const CHARGEBEE_SYNC_STATUS = 'Chargebee_Sync_Status__c';

    /**
     * Linked subscription inside chargebee
     */
    const CHARGEBEE_SUBSCRIPTION_ID = 'Chargebee_Subscription_ID__c';

    /**
     * Date & Time of last status update
     */
    const DATE_MODIFIED_AT = 'Date_Modified_at__c';

    /**
     * Value passed to this field will reflect on the "STATUS" field and it will mark "CHARGEBEE_SYNC_STATUS" to check in a single update request
     */
    const CHARGEBEE_API_STATUS_VALUE = 'Chargebee_API_Status_Value__c';

    /**
     * External Subscription Provider
     */
    const PROVIDER = 'Provider__c';

    /**
     * External Subscription ID
     */
    const EXTERNAL_ID = 'External_Subscription_ID__c';

    /**
     * Collyctor_API_Status_Value__c
     */
    const COLLYCTOR_API_STATUS_VALUE = 'Collyctor_API_Status_Value__c';

    /**
     * Collyctor_Subscription_ID__c
     */
    const COLLYCTOR_SUBSCRIPTION_ID = 'Collyctor_Subscription_ID__c';

    /**
     * Status of syncing data from salesforce to collyctor
     */
    const COLLYCTOR_SYNC_STATUS = 'Collytor_Sync_Status__c';

    /**
     * Created Date
     */
    const CREATED_DATE = 'CreatedDate';

    /**
     * Currency Code
     */
    const CURRENCY_CODE = 'CurrencyIsoCode';

    /**
     * GID Code
     */
    const GID_CODE = 'GID_Code__c';

    /**
     * Is Trial
     */
    const IS_TRIAL = 'Is_Trial__c';

    /**
     * SUBSCRIPTION STAGE
     */
    const SUBSCRIPTION_STAGE = 'Subscription_Stage__c';
}