<?php

namespace learntotrade\salesforce\fields;

class SaleInvoiceFields
{
    /**
     * Invoice name (read-only)
     */
    const NAME = 'Name';

    /**
     * Reference to sale invoice is for
     */
    const SALE = 'Sale__c';

    /**
     * Reference to sale number is for
     */
    const SALE_NUMBER = 'Sale_Number__c';

    /**
     * Amount invoice is for
     */
    const AMOUNT = 'Amount__c';

    /**
     * Currency ISO2 code
     */
    const CURRENCY = 'CurrencyIsoCode';

    /**
     * Date invoice issued/created
     */
    const DATE_ISSUED = 'Date_Issued__c';

    /**
     * Date invoice paid - if this field is populated then a successful payment has been made
     */
    const DATE_PAID = 'Date_Paid__c';

    /**
     * Attempt count - the number of times we've attempted to take payment for the invoice
     */
    const ATTEMPT_COUNT = 'Attempt_Count__c';

    /**
     * Equevalent invoice number on chargebee
     */
    const CHARGEBEE_INVOICE_NUMBER = 'Chargebee_Invoice_Number__c';

    /**
     * Type
     */
    const TYPE = 'Type__c';

    /**
     * Receipt Number. Autogenerated when creating subscription invoice in SF
     */
    const RECEIPT_NUMBER = 'Receipt_Number__c';


    /**
     * Method
     */
    const METHOD = 'Method__c';


    /**
     * TIN
     */
    const TIN = 'TIN__c';

    /**
     * Equevalent invoice number on collyctor
     */
    const COLLYCTOR_INVOICE_NUMBER = 'Collyctor_Invoice_Number__c';
}
