<?php

namespace learntotrade\salesforce\fields;

class SaleFields
{
    /**
     * Customer reference - the customer's casesafe ID is stored as the Customer Name on the Sale
     */
    const CUSTOMER = 'Customer_Name__c';

    /**
     * Date of sale
     */
    const DATE = 'Date_of_Sale__c';

    /**
     * Record type - e.g. 'Child Sale', 'Parent Sale' or 'Simple Sale'
     */
    const RECORD_TYPE_ID = 'RecordTypeId';

    /**
     * Associated product
     */
    const PRODUCT = 'Product__c';

    /**
     * Total number of coaching sessions (writeable)
     */
    const SESSIONS = 'Number_of_Coaching_Sessions__c';

    /**
     * Number of remaining sessions (read-only)
     */
    const SESSIONS_REMAINING = 'Coaching_Sessions_Remaining__c';

    /**
     * Number of booked sessions (read-only)
     */
    const SESSIONS_BOOKED = 'Coaching_Sessions_Booked__c';

    /**
     * Number of cancelled sessions (read-only)
     */
    const SESSIONS_CANCELLED = 'Coaching_Sessions_Cancelled__c';

    /**
     * Number of recredited sessions (read-only)
     */
    const SESSIONS_RECREDITED = 'Coaching_Sessions_Recredited__c';

    /**
     * Expiry date of sale for coaching sessions
     */
    const SESSIONS_EXPIRY = 'Coaching_Expiry_Date__c';

    /**
     * Sale Name
     */
    const SALE_NAME = 'Name';

    /**
     * Currency
     */
    const CURRENCY = 'CurrencyIsoCode';

    /**
     * Payment Schedule
     */
    const PAYMENT_SCHEDULE = 'Payment_Schedule__c';

    /**
     * Deposit Paid
     */
    const DEPOSIT_PAID = 'Deposit_Paid__c';

    /**
     * Date Fully Paid
     */
    const DATE_FULLY_PAID = 'Date_Fully_Paid__c';

    /**
     * Debt Status
     */
    const DEBT_STATUS = 'Debt_Status__c';

    /**
     * Debt Method Of Payment
     */
    const DEBT_METHOD_OF_PAYMENT = 'Debt_Method_Of_Payment__c';

    /**
     * Sale Type
     */
    const SALE_TYPE = 'Sale_Type__c';

    /**
     * Original Booking
     */
    const ORIGINAL_BOOKING = 'Original_Booking__c';

    /**
     * Price
     */
    const PRICE = 'Price__c';

    /**
     * Salesperson Commision
     */
    const SALESPERSON_COMMISSION = 'Salesperson_Commission_a__c';

    /**
     * Rodie Commision
     */
    const ROADIE_COMMISSION = 'Roadie_Commission_a__c';

    /**
     * Coach
     */
    const COACH = 'Coach_1__c';

    /**
     * Date Fully Paid Not Null Parent
     */
    const DATE_FULLY_PAID_NOT_NULL_PARENT = 'Date_Fully_Paid_Not_Null_Parent__c';

    /**
     * Date Fully Paid Not Null
     */
    const DATE_FULLY_PAID_NOT_NULL = 'Date_Fully_Paid_Not_Null__c';

    /**
     * Vat Percent
     */
    const VAT_PERCENT = 'VAT_Percent__c';

    /**
     * Combi Product
     */
    const COMBI_PRODUCT = 'Combi_Product__c';

    /**
     * When Card Added
     */
    const WHEN_CARD_ADDED = 'When_Card_Added__c';

    /**
     * Card Added By
     */
    const CARD_ADDED_BY = 'Card_Added_By__c';

    /**
     * Card in Chargebee
     */
    const CARD_IN_CHARGEBEE = 'Card_in_Chargebee__c';

    /**
     * DATE_PROGRAMME_EXPIRES
     */
    const DATE_PROGRAMME_EXPIRES = 'Date_Programme_Expires__c';

    /**
     * Card in Collyctor
     */
    const CARD_IN_COLLYCTOR = 'Card_in_Collyctor__c';
}
