<?php

namespace learntotrade\salesforce\fields;

class PersonFields
{
    /**
     * Record type - i.e. 'Person Account'
     */
    const RECORD_TYPE_ID = 'RecordTypeID';

    /**
     * Timezone - values taken from a limited picklist, this is a required field on the Account
     */
    const TIMEZONE = 'Time_Zone__c';

    /**
     * Salutation - e.g. 'Mr' or 'Mrs'
     */
    const SALUTATION = 'Salutation';

    /**
     * Account first name
     */
    const FIRST_NAME = 'FirstName';

    /**
     * Account last name
     */
    const LAST_NAME = 'LastName';

    /**
     * Full name generated by Salesforce from the First and Last name fields (read-only)
     */
    const FULL_NAME = 'Name';

    /**
     * Nickname
     */
    const NICKNAME = 'Subscriber_Nickname__c';

    /**
     * Account primary email address
     */
    const EMAIL = 'PersonEmail';

    /**
     * Account's mobile phone number
     */
    const MOBILE = 'PersonMobilePhone';

    /**
     * Account's region
     */
    const REGION = 'Region__c';

    /**
     * Date of birth
     */
    const DATE_OF_BIRTH = 'PersonBirthdate';

    /**
     * Home address house name
     */
    const HOME_HOUSE_NAME = 'PersonMailingHouseName__c';

    /**
     * Home address house number
     */
    const HOME_HOUSE_NUMBER = 'PersonMailingHouseNumber__c';

    /**
     * Home address street
     */
    const HOME_STREET = 'PersonMailingStreet';

    /**
     * Home address city
     */
    const HOME_CITY = 'PersonMailingCity';

    /**
     * Home address state/province
     */
    const HOME_STATE = 'PersonMailingState';

    /**
     * Home address postcode
     */
    const HOME_POSTCODE = 'PersonMailingPostalCode';

    /**
     * Home address country
     */
    const HOME_COUNTRY = 'PersonMailingCountry';

    /**
     * Billing address house name
     */
    const BILLING_HOUSE_NAME = 'BillingHouseName__c';

    /**
     * Billing address house number
     */
    const BILLING_HOUSE_NUMBER = 'BillingHouseNumber__c';

    /**
     * Billing address street
     */
    const BILLING_STREET = 'BillingStreet';

    /**
     * Billing address city
     */
    const BILLING_CITY = 'BillingCity';

    /**
     * Billing address state/province
     */
    const BILLING_STATE = 'BillingState';

    /**
     * Billing address postcode
     */
    const BILLING_POSTCODE = 'BillingPostalCode';

    /**
     * Billing address country
     */
    const BILLING_COUNTRY = 'BillingCountry';

    /**
     * Experience - Non-professional / Professional
     */
    const EXPERIENCE = 'Subscriber_Experience__c';

    /**
     * Profile picture URL
     */
    const PROFILE_PIC_URL = 'Subscriber_Image_URL__c';

    /**
     * Learn Forex Version ENUM - v1 / v2 ... up to v7
     */
    const LEARN_FOREX_VERSION = 'Learn_Forex_Version__c';

    /**
     * Trading Account Type ENUM - DEMO / Live / UAT
     */
    const TRADING_ACCOUNT_TYPE = 'Trading_Account_Type__c';

    /**
     * The ID for the last used trading account of a user
     */
    const LATEST_TRADING_ACCOUNT_ID = 'Latest_Account_Used__c';

    /**
     * The client ID for the last used trading account of a user
     */
    const TRADING_CLIENT_ID = 'Latest_Client_Account_ID_Used__c';

    /**
     * Language Code - 2 character code
     */
    const LANGUAGE = 'Subscriber_Language_Code__c';

    /**
     * Smartcharts SC2 Theme - Default "Dark Theme"
     */
    // const SC2_THEME = 'SmartCharts2_Theme__c';

    /**
     * Accepted Terms BOOLEAN
     */
    const ACCEPTED_TERMS = 'Accepted_Terms_and_Conditions__c';

    /*
     * Date Terms were accepted
     */
    const ACCEPTED_TERMS_DATE = 'Subscriber_Current_Terms_and_Conditions__c';

    /**
     * Foreign key to the coach associated with the account
     */
    const COACH = 'Last_Coach2__c';

    /**
     * Trading Coach used exclusively by FXBlue (not the same as the mentor coaches)
     */
    const TRADING_COACH = 'Trading_Coach__c';

    /**
     * The maxmimum number of devices that a user is allowed to login to at one time
     */
    const NUMBER_OF_DEVICES = 'Subscription_Number_of_Devices__c';

    /**
     * Flag which represents whether this is the users first time logging in to SmartCharts. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const FIRST_LOG_IN = 'First_Log_In__c';

    /**
     * A date time value representing when a user last logged into SmartCharts
     */
    const LAST_LOG_IN_DATE = 'Last_Log_In_Date_Smartcharts__c';

    /**
     * Flag for whether or not a user enrolled via the marketing journey (boolean)
     */
    const ENROLLED_VIA_MARKETING = 'Enrolled_Via_Marketing__c';

    /**
     * Chargebee customer id
     */
    const CHARGEBEE_CUSTOMER_ID = 'Chargebee_ID__c';

    /**
     * The ID for the last used Capital Index trading account of a user
     */
    const LATEST_CAPITAL_INDEX_TRADING_ACCOUNT_ID = 'Latest_Capital_Index_Account_Used__c';

    /**
     * The client ID for the last used Capital Index trading account of a user
     */
    const LATEST_CAPITAL_INDEX_TRADING_CLIENT_ID = 'Latest_Capital_Index_Client_Acc_ID_Used__c';

    /**
     * Capital Index Trading Account Type ENUM - DEMO / Live / UAT
     */
    const CAPITAL_INDEX_TRADING_ACCOUNT_TYPE = 'Capital_Index_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to Capital Index. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const CAPITAL_INDEX_FIRST_LOG_IN = 'First_Capital_Index_Log_In__c';

    /**
     * A date time value representing when a user last logged into Capital Index
     */
    const CAPITAL_INDEX_LAST_LOG_IN_DATE = 'Last_Capital_Index_Log_In_Date__c';

    /**
     * The ID for the last used Capital Index (UK) trading account of a user
     */
    const LATEST_CAPITAL_INDEX_UK_TRADING_ACCOUNT_ID = 'Latest_Capital_Index_UK_Account_Used__c';

    /**
     * The client ID for the last used Capital Index (UK) trading account of a user
     */
    const LATEST_CAPITAL_INDEX_UK_TRADING_CLIENT_ID = 'Latest_Capital_Index_UK_Client_Account__c';

    /**
     * Capital Index (UK) Trading Account Type ENUM - DEMO / Live / UAT
     */
    const CAPITAL_INDEX_UK_TRADING_ACCOUNT_TYPE = 'Capital_Index_UK_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to Capital Index (UK). 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const CAPITAL_INDEX_UK_FIRST_LOG_IN = 'First_Capital_Index_UK_Log_In__c';

    /**
     * A date time value representing when a user last logged into Capital Index (UK)
     */
    const CAPITAL_INDEX_UK_LAST_LOG_IN_DATE = 'Last_Capital_Index_UK_Log_In_Date__c';

    /**
     * The ID for the last used Forex CFDS trading account of a user
     */
    const LATEST_FOREX_CFDS_TRADING_ACCOUNT_ID = 'Latest_ForexCFDs_Account_Used__c';

    /**
     * The client ID for the last used Forex CFDS trading account of a user
     */
    const LATEST_FOREX_CFDS_TRADING_CLIENT_ID = 'Latest_ForexCFDs_Client_Account_ID_Used__c';

    /**
     * Forex CFDS Trading Account Type ENUM - DEMO / Live / UAT
     */
    const FOREX_CFDS_TRADING_ACCOUNT_TYPE = 'ForexCFDs_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to Forex CFDS. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const FOREX_CFDS_FIRST_LOG_IN = 'First_ForexCFDs_Log_In__c';

    /**
     * A date time value representing when a user last logged into Forex CFDS
     */
    const FOREX_CFDS_LAST_LOG_IN_DATE = 'Last_ForexCFDs_Log_In_Date__c';

    /**
     * The ID for the last used Your Broker trading account of a user
     */
    const LATEST_YOUR_BROKER_TRADING_ACCOUNT_ID = 'Latest_Your_Broker_Account_Used__c';

    /**
     * The client ID for the last used Your Broker trading account of a user
     */
    const LATEST_YOUR_BROKER_TRADING_CLIENT_ID = 'Latest_Your_Broker_Client_Acc_ID_Used__c';

    /**
     * Your Broker Trading Account Type ENUM - DEMO / Live / UAT
     */
    const YOUR_BROKER_TRADING_ACCOUNT_TYPE = 'Your_Broker_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to Your Broker. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const YOUR_BROKER_FIRST_LOG_IN = 'First_Your_Broker_Log_In__c';

    /**
     * A date time value representing when a user last logged into Your Broker
     */
    const YOUR_BROKER_LAST_LOG_IN_DATE = 'Last_Your_Broker_Log_In_Date__c';

    /**
     * To identify if user SC2 or LTT customer. Values ('Smart Charts', 'Learn To Trade')
     */
    const CUSTOMER_GROUP = 'Customer_Group__c';

    /**
     * GID Code to map user to a campaign
     */
    const GID_CODE = 'GID_Code__c';

    /**
     * Flag if a user can access the coaching platform
     */
    const CAN_ACCESS_COACHING = 'Can_Access_Coaching__c';

    /**
     * Flag if a user can access the journal
     */
    const CAN_ACCESS_JOURNAL = 'Can_Access_Journal__c';

    /**
     * Flag if a user can access the coaching platform demo
     */
    const CAN_ACCESS_COACHING_DEMO = 'Can_Access_Coaching_in_Demo__c';

    /**
     * Flag if a user can access the journal demo
     */
    const CAN_ACCESS_JOURNAL_DEMO = 'Can_Access_Journal_in_Demo__c';

    /**
     * The Customer's Number in integer
     */
    const CUSTOMER_NUMBER = 'Customer_Number__c';

    /**
     * BADGE_LEVEL 
     * Note: Work Around Temporary -Sam 07/28/25
     */
    //const BADGE_LEVEL = 'Badge_Level__c';
    const BADGE_LEVEL = 'Skype__c';

    /**
     * BADGE_LEVEL_DATE_QUALIFIED
     * Note: Work Around Temporary -Sam 07/28/25
     */
    //const BADGE_LEVEL_DATE_QUALIFIED = 'Badge_Level_Date_Qualified__c';
    const BADGE_LEVEL_DATE_QUALIFIED = 'Last_Reset_Date__pc';

    /**
     * Customer Type
     */
    const CUSTOMER_TYPE = 'Customer_Type__c';

    /**
     * Encrypted_Email__pc
     */
    const ENCRYPTED_EMAIL = 'Encrypted_Email__pc';

    /**
     * The ID for the last used ForexCFDsAus trading account of a user
     */
    //const LATEST_FOREX_CFDS_AUS_TRADING_ACCOUNT_ID = 'Latest_ForexCFDsAUS_Account_Used__c';

    /**
     * The client ID for the last used ForexCFDsAus trading account of a user
     */
    //const LATEST_FOREX_CFDS_AUS_TRADING_CLIENT_ID = 'Latest_ForexCFDsAUS_Client_Acc_ID_Used__c';

    /**
     * ForexCFDsAus Trading Account Type ENUM - DEMO / Live / UAT
     */
    //const FOREX_CFDS_AUS_TRADING_ACCOUNT_TYPE = 'ForexCFDsAUS_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to ForexCFDsAus. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    //const FOREX_CFDS_AUS_FIRST_LOG_IN = 'First_ForexCFDsAUS_Log_In__c';

    /**
     * A date time value representing when a user last logged into ForexCFDsAus
     */
    //const FOREX_CFDS_AUS_LAST_LOG_IN_DATE = 'Last_ForexCFDsAUS_Log_In_Date__c';

    /**
     * The ID for the last used ForexCFDsAus trading account of a user
     */
    const Latest_ForexCIEurope_Account_Used = 'Latest_ForexCIEurope_Account_Used__c';

    /**
     * The client ID for the last used ForexCFDsAus trading account of a user
     */
    const Latest_ForexCIEurope_Client_Acc_ID_Used = 'Latest_ForexCIEurope_Client_Acc_ID_Used__c';

    /**
     * ForexCFDsAus Trading Account Type ENUM - DEMO / Live / UAT
     */
    const ForexCIEurope_Trading_Account_Type = 'ForexCIEurope_Trading_Account_Type__c';

    /**
     * Flag which represents whether this is the users first time logging in to ForexCFDsAus. 3 possible values:
     * blank = newly created record
     * 'Yes' = First login after enrolment completed
     * 'No' = Second, third etc logins
     */
    const First_ForexCIEurope_Log_In = 'First_ForexCIEurope_Log_In__c';

    /**
     * A date time value representing when a user last logged into ForexCFDsAus
     */
    const Last_ForexCIEurope_Log_In_Date = 'Last_ForexCIEurope_Log_In_Date__c';

    /**
     * Can Access Tools
     */
    const CAN_ACCESS_TOOLS = 'Can_Access_Tools__c';

    /**
     * Trade Compass
     */
    const TRADE_COMPASS = 'Trade_Compass__c';

    /**
     * 	markets.com Trading Account Type
     */
    const MARKETS_TRADING_ACCOUNT_TYPE = 'markets_com_Trading_Account_Type__c';

    /**
     * 	First markets.com Log In
     */
    const MARKETS_FIRST_LOG_IN = 'First_markets_com_Log_In__c';

    /**
     * 	Last markets.com Log In Date
     */
    const MARKETS_LAST_LOG_IN_DATE = 'Last_markets_com_Log_In_Date__c';

    /**
     * 	Latest markets.com Account Used
     */
    const MARKETS_LATEST_ACCOUNT_USED = 'Latest_markets_com_Account_Used__c';

    /**
     * 	Latest markets.com Client Acc ID Used
     */
    const MARKETS_LATEST_CLIENT_ACCOUNT_ID_USED = 'Latest_markets_com_Client_Acc_ID_Used__c';

    /**
     * 	Retention Status
     */
    const RETENTION_STATUS = 'Retention_Status__c';

    /**
     * 	Coach ID
     */
    const COACH_ID = 'Coach_ID__c';

    /**
     * 	Coach Image
     */
    const COACH_IMAGE = 'Coach_Image__c';

    /**
     * Collyctor customer id
     */
    const COLLYCTOR_ID = 'Collyctor_ID__c';

    /**
     * 	Thinkmarkets Trading Account Type
     */
    const THINKMARKETS_TRADING_ACCOUNT_TYPE = 'ThinkMarkets_Trading_Account_Type__c';

    /**
     * 	First Thinkmarkets Log In
     */
    const THINKMARKETS_FIRST_LOG_IN = 'First_ThinkMarkets_Log_In__c';

    /**
     * 	Last Thinkmarkets Log In Date
     */
    const THINKMARKETS_LAST_LOG_IN_DATE = 'Last_ThinkMarkets_Log_In_Date__c';

    /**
     * 	Latest Thinkmarkets Account Used
     */
    const THINKMARKETS_LATEST_ACCOUNT_USED = 'Latest_ThinkMarkets_Account_Used__c';

    /**
     * 	Latest Thinkmarkets Client Acc ID Used
     */
    const THINKMARKETS_LATEST_CLIENT_ACCOUNT_ID_USED = 'Latest_ThinkMarkets_Client_Acc_ID_Used__c';

    /**
     * 	Intertrader Trading Account Type
     */
    const INTERTRADER_TRADING_ACCOUNT_TYPE = 'Intertrader_Trading_Account_Type__c';

    /**
     * 	First Intertrader Log In
     */
    const INTERTRADER_FIRST_LOG_IN = 'First_Intertrader_Log_In__c';

    /**
     * 	Last Intertrader Log In Date
     */
    const INTERTRADER_LAST_LOG_IN_DATE = 'Last_Intertrader_Log_In_Date__c';

    /**
     * 	Latest Intertrader Account Used
     */
    const INTERTRADER_LATEST_ACCOUNT_USED = 'Latest_Intertrader_Account_Used__c';

    /**
     * 	Latest Intertrader Client Acc ID Used
     */
    const INTERTRADER_LATEST_CLIENT_ACCOUNT_ID_USED = 'Latest_Intertrader_Client_Acc_ID_Used__c';

    /**
     * Community Picks Admin
     */
    const COMMUNITY_PICKS_ADMIN = 'Community_Picks_Admin__c';

    /**
     * Community Picks Blocked
     */
    const COMMUNITY_PICKS_BLOCKED = 'Community_Picks_Blocked__c';
}
