<?php

namespace learntotrade\salesforce\fields;

class CoachingSessionFields
{
    /**
     * Date of the session
     */
    const DATE = 'Date__c';

    /**
     * Session start time
     */
    const START_TIME = 'Start_Time__c';

    /**
     * Session end time
     */
    const END_TIME = 'End_Time__c';

    /**
     * Session status - represents whether the session has been booked, cancelled, a no show or
     * attended.
     */
    const STATUS = 'Status__c';

    /**
     * Availability type - represents whether the mentor can do the session in-house, remotely or
     * both.
     */
    const AVAILABILITY_TYPE = 'Availability_Type__c';

    /**
     * The session's coach/mentor
     */
    const COACH = 'Coach__c';

    /**
     * Location of the booked session - remote or in-house.
     */
    const LOCATION = 'Location__c';

    /**
     * Sale associated with the session - we can use this to determine the customer linked to the
     * session.
     */
    const SALE = 'Sale__c';

    /**
     * Zoom URL - URL to the remote video sessions
     */
    const ZOOM_URL = 'Zoom_URL__c';

    /**
     * Name of the customer booked to the session
     */
    const CUSTOMER_NAME = 'Customer__c';

    /**
     * Cancelled to be recredited
     */
    const CANCELLED_TO_BE_RECREDITED = 'Cancelled_to_be_recredited__c';

    /**
     * PREVIOUSLY_CANCELLED
     */
    const PREVIOUSLY_CANCELLED = 'Previously_Cancelled__c';

    /**
     * COACHING_EXPIRY_DATE
     */
    const COACHING_EXPIRY_DATE = 'Coaching_Expiry_Date__c';

    /**
     * TRANSLATED_DAY
     */
    const TRANSLATED_DAY = 'Translated_Day__c';

    /**
     * TRANSLATED_DESTINATION_TIME_ZONE
     */
    const TRANSLATED_DESTINATION_TIME_ZONE = 'Translated_Destination_Time_Zone__c';

    /**
     * TRANSLATED_END_TIME
     */
    const TRANSLATED_END_TIME = 'Translated_End_Time__c';

    /**
     * TRANSLATED_MONTH
     */
    const TRANSLATED_MONTH = 'Translated_Month__c';

    /**
     * TRANSLATED_SOURCE_TIME_ZONE
     */
    const TRANSLATED_SOURCE_TIME_ZONE = 'Translated_Source_Time_Zone__c';

    /**
     * TRANSLATED_START_TIME
     */
    const TRANSLATED_START_TIME = 'Translated_Start_Time__c';

    /**
     * TRANSLATED_YEAR
     */
    const TRANSLATED_YEAR = 'Translated_Year__c';

    /**
     * SORT
     */
    const SORT = 'Sort__c';
}
