#EVWishlist
This plugin allows you to add a customer wishlist system to your shop. It's currently designed to work with the products table in EvShop (it's trivial to change it to work on another table however).

The plugin provides an ajax based add/remove, allowing you to have a 'add to wishlist' button on your products that when clicked will post off to the plugin via ajax and add the item to the wishlist.

A page is also provided to show what items are on the customers wishlist.

There is no admin interface for this plugin (other than the auto-generated one however it's not used or needed).

##Installation
This plugin supports the cake shell installer. Take a look at the core-cms docs for details on how to use this.

Migration files are also included should you wish to manually set the plugin up using the migrations.

In your AppController you'll need to initialise the plugin in the constructor like so:

    if (CakePlugin::loaded('EvWishlist')) {
        $this->components[] = 'EvWishlist.Wishlist';
        $this->helpers[] = 'EvWishlist.Wishlist';
    }

#Usage
The plugin relies on a javascript file to add/remove wishlist items on the fly. You can either include this once globally or you can do it as-needed. Even if you try including it more than once, the javascript should still only be injected into your html once.

To inject the html, place this somewhere in your listing item / product view template:

    <?php echo $this->Wishlist->injectJs(); ?>
For your add to / remove from wishlist button, this should just be a link with a blank target. It should have a class called 'add-to-wishlist', and two data attributes for the model (Currently this is always going to be EvShop.Product) and the model id.

An example of how this works on Artistic Flair is as follows:

    <a href="#" class="icon icon--favourite icon--large add-to-wishlist <?=$activeClass?>"  data-model="EvShop.Product" data-id="<?php echo $data['Product']['id']; ?>">Favourite</a>

In the above example we're also making use of the helper to detect if the item has already been added to the wishlist (so we can show that it's active already). This is done with the following code:

    <?php
    $activeClass = '';
    if (isset($wishlistItems['EvShop.Product'][$data['Product']['id']])):
        $activeClass = 'active';
    endif;
    ?>


The javascript for the plugin will temporarily add a loading class to the link whilst the ajax request is processing. It'll then remove  it and either add an active class or remove it depending on the action you're performing.

This does obviously mean that the plugin doesn't support having a button with the words 'Add to Wishlist' and 'Remove from Wishlist' on them yet. To do this you should either extend the plugin, or add your own javascript in that can amend the link after the ajax call is finished.

To do the latter option, two jquery triggers are already provided, so you should be able to just listen for that firing, and then run your own JS. The two triggers are:

- wishlist_removed
- wishlist_added

## Wishlist Item Count

You may want to echo out the number of items in a user's wishlist. This is similar to the Basket, in which there would be a link to the basket in the header of the site with a number in brackets stating how many items there are.

The `WishlistItem` model function `getItemCount($userId, $params = [])` can be used for this.

The function accepts two parameters; `$userId` is mandatory and is the ID of the logged-in user who's items you are counting. `$params` is an optional array of extra parameters you can pass in to the count query.

#Dev Plugin Info

##Indexes

- `wishlist_items_user_id_model_model_id` => A multi-column index that covers the user_id, model and model_id fields in that order. Useful for when getting wishlist items for a user.





