<?php
App::uses('EvWishlistAppController', 'EvWishlist.Controller');

class WishlistItemsController extends EvWishlistAppController {

	public $components = [
		'EvWishlist.Wishlist',
	];

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'add_item',
			'delete_item',
		));
	}

	public function index() {
		$wishlistItems = $this->{$this->modelClass}->find('all', array(
			'conditions' => array(
				'user_id' => $this->Auth->user('User.id')
			)
		));

		$wishlistEntrys = array();

		foreach ($wishlistItems as $wishlistItem) {

			// load the model for the wishlist item
			$model = EvClassRegistry::init($wishlistItem['WishlistItem']['model']);

			$record = $model->find('first', array(
				'conditions' => array(
					'id' => $wishlistItem['WishlistItem']['model_id']
				),
				'callbacks' => false
			));

			if (! empty($record)) {

				$controller = Inflector::underscore(Inflector::pluralize($model->alias));
				$modelParts = explode(".", $wishlistItem['WishlistItem']['model']);
				$plugin = Inflector::underscore($modelParts[0]);

				// Work out item url
				$itemUrl = Router::url(array(
					'controller' => $controller,
					'action' => 'view',
					'plugin' => $plugin,
					$wishlistItem['WishlistItem']['model_id']
				));

				$wishlistEntrys[$wishlistItem['WishlistItem']['id']] = array(
					'name' => $record[$model->alias]['name'],
					'url' => $itemUrl,
					'id' => $wishlistItem['WishlistItem']['id'],
					'date' => $wishlistItem['WishlistItem']['created']
				);
			}
		}

		$this->set('wishlist', $wishlistEntrys);
	}

	public function add() {
		$this->autoRender = false;

		if ($this->request->is('post') &&
			! empty($this->request->data['model']) &&
			! empty($this->request->data['model_id']) &&
			$this->Auth->user()) {

			// all good - add the record
			if (
				$this->{$this->modelClass}->save(
					array(
						'user_id' => $this->Auth->user('User.id'),
						'model' => $this->request->data['model'],
						'model_id' => $this->request->data['model_id'],
					)
				)
			) {
				return '1';
			}
		}

		return '0';
	}

	public function delete($id) {
		if ($this->request->isAjax()) {
			return $this->ajax_delete();
		}

		// Check if the user owns that record!
		$item = $this->{$this->modelClass}->find('first', array(
			'conditions' => array(
				'id' => $id
			),
			'callbacks' => false
		));

		if (! empty($item) && $item['WishlistItem']['user_id'] === $this->Auth->user('User.id')) {
			// The user owns this wishlist item so let them delete it.
			if ($this->{$this->modelClass}->delete($item['WishlistItem']['id'])) {

				$this->Session->setFlash('Your wishlist item has been successfully removed.', 'flash_success');

				return $this->redirect(
					array(
						'plugin' => 'ev_wishlist',
						'controller' => 'wishlist_items',
						'action' => 'index'
					)
				);
			}

		} else {
			$this->Session->setFlash('The wishlist item you are trying to delete could not be found.<br>Please press the delete button on the individual item you wish to delete from your list below.', 'flash_fail');

			return $this->redirect(
				array(
					'plugin' => 'ev_wishlist',
					'controller' => 'wishlist_items',
					'action' => 'index'
				)
			);
		}
	}

	public function ajax_delete() {
		$this->autoRender = false;

		if ($this->request->is('post') &&
			! empty($this->request->data['model']) &&
			! empty($this->request->data['model_id'])) {

			// Check if the user owns that record!
			$item = $this->{$this->modelClass}->find('first', array(
				'conditions' => array(
					'user_id' => $this->Auth->user('User.id'),
					'model' => $this->request->data['model'],
					'model_id' => $this->request->data['model_id'],
				),
				'callbacks' => false
			));

			if (! empty($item)) {
				// The user owns this wishlist item so let them delete it.
				if ($this->{$this->modelClass}->delete($item['WishlistItem']['id'])) {
					return '1';
				}
			}
		}
		return '0';
	}

/**
 * Add a wishlist item to the currently logged in user's wishlist.
 *
 * @param string $model   The model name of the item to add.
 * @param int    $modelId The id of the item to add.
 * @return void. Returns to the previous page.
 */
	public function add_item($model, $modelId) {
		$redirect = $this->Wishlist->getRedirect('add');

		if ($this->Wishlist->addItem($model, $modelId)) {
			$this->Flash->success(
				Configure::read('EvWishlist.flash.add.success')
			);
		} else {
			$this->Flash->fail(
				Configure::read('EvWishlist.flash.add.fail')
			);
		}

		$this->redirect($redirect);
	}

/**
 * Remove a wishlist item from the currently logged in user's wishlist.
 *
 * @param string $model   The model name of the item to add.
 * @param int    $modelId The id of the item to add.
 * @return void. Returns to the previous page.
 */
	public function delete_item($model, $modelId) {
		$redirect = $this->Wishlist->getRedirect('delete');

		if ($this->Wishlist->deleteItem($model, $modelId)) {
			$this->Flash->success(
				Configure::read('EvWishlist.flash.delete.success')
			);
		} else {
			$this->Flash->fail(
				Configure::read('EvWishlist.flash.delete.fail')
			);
		}

		$this->redirect($redirect);
	}
}
