<?php

App::uses('EvWishlistAppModel', 'EvWishlist.Model');

class WishlistItem extends EvWishlistAppModel {

	public $belongsTo = [
		'User' => [
			'className' => 'User',
			'foreignKey' => 'user_id',
		]
	];

/**
 * Get an item for a user based off of the model, model_id and the user_id.
 *
 * @param string $model   The name of the model of the item to get.
 * @param int    $modelId The model id of the item to get.
 * @param int    $userId  The id of the user to get the item for.
 * @return array
 */
	public function getItemForUser($model, $modelId, $userId) {
		return $this->find(
			'first',
			[
				'conditions' => [
					'WishlistItem.user_id' => $userId,
					'WishlistItem.model' => $model,
					'WishlistItem.model_id' => $modelId,
				]
			]
		);
	}
}
