<?php

$config = array(
	'EvWishlist' => array(
		'route' => array(
			'WishlistItem' => array(
				'controller' => 'ev_wishlist.wishlist_items',
				'action' => 'index',
				'plugin' => 'EvWishlist'
			),
			'DeleteWishlistItem' => array(
				'controller' => 'ev_wishlist.wishlist_items',
				'action' => 'delete',
				'plugin' => 'EvWishlist'
			),
			'AddWishlistItem' => array(
				'controller' => 'ev_wishlist.wishlist_items',
				'action' => 'add',
				'plugin' => 'EvWishlist'
			),
			'AddItemToWishlist' => array( //The url used on the add-to-wishlist element
				'plugin' => 'EvWishlist',
				'controller' => 'ev_wishlist.wishlist_items',
				'action' => 'add_item',
			),
			'DeleteItemFromWishlist' => array( //The url used on the add-to-wishlist element
				'plugin' => 'EvWishlist',
				'controller' => 'ev_wishlist.wishlist_items',
				'action' => 'delete_item',
			),
		),

		'redirects' => array(
			'add' => null, // url array or `null` to use $this->referer()
			'delete' => null, // url array or `null` to use $this->referer()
			'afterLogin' => array(
				'plugin' => 'ev_wishlist',
				'controller' => 'wishlist_items',
				'action' => 'index',
			),
		),

		'flash' => array(
			'add' => array(
				'success' => array(
					'title' => 'Wishlist item added',
					'description' => 'Your wishlist item was succesfully added to your wishlist.',
				),
				'fail' => array(
					'title' => 'Failed',
					'description' => 'Your wishlist item was not added to your wishlist.',
				),
			),
			'delete' => array(
				'success' => array(
					'title' => 'Wishlist item removed.',
					'description' => 'Your wishlist item was succesfully removed to your wishlist.',
				),
				'fail' => array(
					'title' => 'Failed',
					'description' => 'Your wishlist item was not removed to your wishlist.',
				),
			),
		),
	)
);
